import matplotlib.pyplot as plt
import seaborn as sns
import os
from sklearn.preprocessing import LabelEncoder
from sklearn.model_selection import train_test_split
from sklearn.metrics import classification_report, confusion_matrix
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import accuracy_score
from sklearn.preprocessing import StandardScaler
from sklearn.cluster import KMeans
from sklearn.metrics import silhouette_score
import numpy as np
from scipy import stats
import sys
sys.path.append(sys.argv[1])

import pandas as pd  
import matplotlib.pyplot as plt  
from decision_company import read_csv_file, create_subplots, get_fig_from_df, count_unique_values, set_layout, save_plot, show_plots

# Load the dataset  
credit_customers = read_csv_file(os.path.join(sys.argv[1], 'credit_customers.csv'))  

# Plot histograms  
fig, axes = create_subplots(2, 2, figsize=(12, 8))  
  
get_fig_from_df(count_unique_values(credit_customers['credit_history']),kind='bar', ax=axes[0, 0], title='Credit History')  
get_fig_from_df(count_unique_values(credit_customers['employment']), kind='bar', ax=axes[0, 1], title='Employment')  
get_fig_from_df(credit_customers['age'],kind='hist', bins=20, ax=axes[1, 0], title='Age')  
get_fig_from_df(credit_customers['credit_amount'], kind='hist', bins=20, ax=axes[1, 1], title='Credit Amount')  

set_layout() 
save_plot('ref_result/subplots.png') 
# show_plots()  

import pandas as pd   
import pickle
from decision_company import read_csv_file, count_unique_values, bind_dataframe, pivot_a_level, fill_missing_values

# Load the dataset  

# Calculate approval rates  
credit_history_group = bind_dataframe(credit_customers, 'credit_history')  
credit_history_counts = count_unique_values(credit_history_group['class'], normalize=True)  
approval_rates_credit_history = fill_missing_values(pivot_a_level(credit_history_counts), value=0)['good']    

print(approval_rates_credit_history)
# pickle.dump(approval_rates_credit_history,open("./ref_result/approval_rates_credit_history.pkl","wb"))

  

import pandas as pd   
import pickle
from decision_company import read_csv_file, count_unique_values, bind_dataframe, pivot_a_level, fill_missing_values

# Load the dataset  
  
employment_group = bind_dataframe(credit_customers, 'employment')  
employment_counts = count_unique_values(employment_group['class'], normalize=True)  
approval_rates_employment = fill_missing_values(pivot_a_level(employment_counts), value=0)['good']  
 
print(approval_rates_employment)
# pickle.dump(approval_rates_employment,open("./ref_result/approval_rates_employment.pkl","wb"))

  

import pandas as pd   
import pickle
from decision_company import read_csv_file, count_unique_values, bind_dataframe, pivot_a_level, fill_missing_values, logical_and, filter_by_condition 

# Load the dataset  
  
age_column = credit_customers['age'] 
middle_age_condition = logical_and(age_column > 40, age_column < 59)  
middle_age_customers = filter_by_condition(credit_customers, middle_age_condition)  
middle_age_group = bind_dataframe(middle_age_customers, 'age')  
middle_age_counts = count_unique_values(middle_age_group['class'], normalize=True)  
approval_rates_middle_age = fill_missing_values(pivot_a_level(middle_age_counts), value=0)['good']  
 
print(approval_rates_middle_age)
# pickle.dump(approval_rates_middle_age,open("./ref_result/approval_rates_middle_age.pkl","wb"))

  



import pandas as pd   
import pickle
from decision_company import read_csv_file, get_fig_from_df, count_unique_values, set_layout, bind_dataframe, pivot_a_level, fill_missing_values, create_subplots, show_plots, save_plot, fetch_column, logical_and, filter_by_condition, make_bins 

# Load the dataset  
  
credit_customers['credit_amount_range'] = make_bins(credit_customers['credit_amount'], bins=[0, 2000, 4000, 6000, 8000, 10000, 12000, 14000, 16000, 18000, 20000], include_lowest=True)  
credit_amount_group = bind_dataframe(credit_customers, 'credit_amount_range')  
credit_amount_counts = count_unique_values(credit_amount_group['class'], normalize=True)  
approval_rates_credit_amount = fill_missing_values(pivot_a_level(credit_amount_counts), value=0)['good']  
 
print(approval_rates_credit_amount)
pickle.dump(approval_rates_credit_amount,open("./ref_result/approval_rates_credit_amount.pkl","wb"))

  